function [ S1,S2 ] = Assembly_gen( delta,r,d,extdeltap,extdeltapd,M_r_d_d,M_rm1_dm1_dm1 )
%Assemble stiffness matrices in S^0_2(delta) for diffusion problem.
%   The diffusion problem in weak formulation is for all basis N_{j}
%   0 = \int_{\Omega} N_{j}\left\{u_{t}-ku_{zz}\right\} 
%     = \sum_{i}{ \int_{\Omega}N_{j}N_{i} }c'_{i} + \sum_{i}{ k\int_{\Omega}N'_{j}N'_{i} }c_{i}
%delta is the original knot sequence, not yet extended. For this example k
%= .75 and \Omega = [0,6]. S_{1} is the matrix coefficient on c' and S_{2}
%is the analogous on c. MAKE SURE delta is a partition of [0,6]

%Build extended knot sequence.
[extdelta,n] = extpar(delta,r,d);
%Find the endpoints of delta.
a = delta(1,1);
b = delta(1,size(delta,2));

%Assemble S1
S1 = zeros(n,n);
In = eye(n); %For easily extracting the basis coefficient vectors.
for i=1:n %columns
    for j=1:n %rows
        Nj = In(j,:);
        Ni = In(i,:);
        Np = prdspl(M_r_d_d,Nj,Ni);
        S1(j,i) = intspl(2*d,extdeltap,Np,a,b); %[a,b] is the interval
    end
end


%Assemble S2
S2 = zeros(n,n);
for i=1:n
    for j=1:n
        Nj = In(j,:);
        Ni = In(i,:);
        [deltad,Njd,nd] = derspl(d,extdelta,Nj); %Compute derivatives
        [deltad,Nid,nd] = derspl(d,extdelta,Ni);
        
        Npd = prdspl(M_rm1_dm1_dm1,Njd,Nid);                   %The derivative continuity is not C0 bc parent was C0.
        S2(j,i) = intspl(d,extdeltapd,Npd,a,b);                %It's actually discontinuous. -1 is formal, not clear if
                                                               %this actually correct.
    end
end

S2 = .75*S2; %Incorporate the diffusion coefficient.



end

